#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Au3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****


#comments-start -----------------------------------------------------------------------------------
	Title.........:	IsPressed Library UDF
	Filename......:	IsPressed UDF.au3
	Description...:	Multiple _IsPressed functions based on original _IsPressed function
	Author........:	FireFox
	Version.......:	02.02.00
	Last Update...:	06.03.09
	Requirements..:	AutoIt v3.2 +, Developed/Tested on WindowsXP Home Service Pack 3
	Notes.........:	All _IsPressed functions works without have to specify the user32.dll
	
	Special thanks to ezzetabi (original _IsPressed function)
	Valuater for __KeyPressCheck ; __GetKeyType functions
	MrCreator for _IsWheelKeyScroll function
#comments-end -------------------------------------------------------------------------------------

#include-once
Opt('OnExitFunc', '__OnAutoItExit')
Global $IsWheelKeyScroll = False, $vUser32
; #FUNCTION# ;===============================================================================
; Name...........: $vUser32
; Description ...: Open 'user32.dll'
; ;==========================================================================================
$vUser32 = DllOpen('user32.dll')


; #FUNCTION# ====================================================================================================================
; Name...........: _IsPressed
; Description ...: Check if key has been pressed
; Syntax.........: _IsPressed($sHexKey[, $vDLL = 'user32.dll'])
; Parameters ....: $sHexKey     - Key to check for
;                  $vDLL        - Handle to dll or default to user32.dll
; Return values .: True         - 1
;                  False        - 0
; Author ........: ezzetabi and Jon
; Modified.......:
; Remarks .......: If calling this function repeatidly, should open 'user32.dll' and pass in handle.
;                  Make sure to close at end of script
;                  01 Left mouse button
;                  02 Right mouse button
;                  04 Middle mouse button (three-button mouse)
;                  05 Windows 2000/XP: X1 mouse button
;                  06 Windows 2000/XP: X2 mouse button
;                  08 BACKSPACE key
;                  09 TAB key
;                  0C CLEAR key
;                  0D ENTER key
;                  10 SHIFT key
;                  11 CTRL key
;                  12 ALT key
;                  13 PAUSE key
;                  14 CAPS LOCK key
;                  1B ESC key
;                  20 SPACEBAR
;                  21 PAGE UP key
;                  22 PAGE DOWN key
;                  23 END key
;                  24 HOME key
;                  25 LEFT ARROW key
;                  26 UP ARROW key
;                  27 RIGHT ARROW key
;                  28 DOWN ARROW key
;                  29 SELECT key
;                  2A PRINT key
;                  2B EXECUTE key
;                  2C PRINT SCREEN key
;                  2D INS key
;                  2E DEL key
;                  30 0 key
;                  31 1 key
;                  32 2 key
;                  33 3 key
;                  34 4 key
;                  35 5 key
;                  36 6 key
;                  37 7 key
;                  38 8 key
;                  39 9 key
;                  41 A key
;                  42 B key
;                  43 C key
;                  44 D key
;                  45 E key
;                  46 F key
;                  47 G key
;                  48 H key
;                  49 I key
;                  4A J key
;                  4B K key
;                  4C L key
;                  4D M key
;                  4E N key
;                  4F O key
;                  50 P key
;                  51 Q key
;                  52 R key
;                  53 S key
;                  54 T key
;                  55 U key
;                  56 V key
;                  57 W key
;                  58 X key
;                  59 Y key
;                  5A Z key
;                  5B Left Windows key
;                  5C Right Windows key
;                  60 Numeric keypad 0 key
;                  61 Numeric keypad 1 key
;                  62 Numeric keypad 2 key
;                  63 Numeric keypad 3 key
;                  64 Numeric keypad 4 key
;                  65 Numeric keypad 5 key
;                  66 Numeric keypad 6 key
;                  67 Numeric keypad 7 key
;                  68 Numeric keypad 8 key
;                  69 Numeric keypad 9 key
;                  6A Multiply key
;                  6B Add key
;                  6C Separator key
;                  6D Subtract key
;                  6E Decimal key
;                  6F Divide key
;                  70 F1 key
;                  71 F2 key
;                  72 F3 key
;                  73 F4 key
;                  74 F5 key
;                  75 F6 key
;                  76 F7 key
;                  77 F8 key
;                  78 F9 key
;                  79 F10 key
;                  7A F11 key
;                  7B F12 key
;                  7C-7F F13 key - F16 key
;                  80H-87H F17 key - F24 key
;                  90 NUM LOCK key
;                  91 SCROLL LOCK key
;                  A0 Left SHIFT key
;                  A1 Right SHIFT key
;                  A2 Left CONTROL key
;                  A3 Right CONTROL key
;                  A4 Left MENU key
;                  A5 Right MENU key
;                  BA ;
;                  BB =
;                  BC ,
;                  BD -
;                  BE .
;                  BF /
;                  C0 `
;                  DB [
;                  DC \
;                  DD ]
; Related .......:
; Link ..........;
; Example .......; Yes
; ===============================================================================================================================
Func _IsPressed($sHexKey, $vDLL = 'user32.dll')
	; $hexKey must be the value of one of the keys.
	; _Is_Key_Pressed will return 0 if the key is not pressed, 1 if it is.
	Local $a_R = DllCall($vDLL, "int", "GetAsyncKeyState", "int", '0x' & $sHexKey)
	If Not @error And BitAND($a_R[0], 0x8000) = 0x8000 Then Return 1
	Return 0
EndFunc   ;==>_IsPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsAnyKeyPressed
; Description ...: Returns if any key is pressed
; Syntax.........: _IsAnyKeyPressed($vDLL = 'user32.dll')
; Parameters ....: $vDLL = the dll to use for __KeyPressCheck
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __KeyPressCheck
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsAnyKeyPressed($vDLL = 'user32.dll')
	If __KeyPressCheck(1, 221, -1, $vDLL) Then Return 1
	Return 0
EndFunc   ;==>_IsAnyKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsOrKeyPressed
; Description ...: Returns if any key specified is pressed
; Syntax.........: _IsOrKeyPressed($HexKey, $vDLL = 'user32.dll')
; Parameters ....: $HexKey = Hexadecimal key(s) seperated by '|'
;				   $vDLL   = the dll to use for __KeyPressCheck
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __KeyPressCheck
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsOrKeyPressed($sHexKey, $vDLL = 'user32.dll')
	Local $iKey, $sKey = StringSplit($sHexKey, '|', 1)
	
	For $iKey = 1 To UBound($sKey) - 1
		If __KeyPressCheck(1, 1, $sKey[$iKey], $vDLL) Then Return 1
	Next
	Return 0
EndFunc   ;==>_IsOrKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsAndKeyPressed
; Description ...: Returns if all keys specified are pressed
; Syntax.........: _IsAndKeyPressed($HexKey, $vDLL = 'user32.dll')
; Parameters ....: $HexKey = Hexadecimal key(s) seperated by '|'
;				   $vDLL   = the dll to use for __KeyPressCheck
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __KeyPressCheck
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsAndKeyPressed($sHexKey, $vDLL = 'user32.dll')
	Local $iKey, $sKey = StringSplit($sHexKey, '|', 1)
	
	For $iKey = 1 To UBound($sKey) - 1
		If Not __KeyPressCheck(1, 1, $sKey[$iKey], $vDLL) Then Return 0
	Next
	Return 1
EndFunc   ;==>_IsAndKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsAlphaKeyPressed
; Description ...: Returns if any alphabetic key is pressed
; Syntax.........: _IsAlphaKeyPressed($vDLL = 'user32.dll')
; Parameters ....: $vDLL   = the dll to use for __KeyPressCheck
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __KeyPressCheck
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsAlphaKeyPressed($vDLL = 'user32.dll')
	If __KeyPressCheck(48, 90, -1, $vDLL) Then Return 1
	Return 0
EndFunc   ;==>_IsAlphaKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsNumKeyPressed
; Description ...: Returns if any numeric key is pressed
; Syntax.........: _IsNumKeyPressed($vDLL = 'user32.dll')
; Parameters ....: $vDLL   = the dll to use for __KeyPressCheck
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __KeyPressCheck
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsNumKeyPressed($vDLL = 'user32.dll')
	If __KeyPressCheck(96, 105, -1, $vDLL) Then Return 1
	Return 0
EndFunc   ;==>_IsNumKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsAlphaNumKeyPressed
; Description ...: Returns if any numeric or alphabetic key is pressed
; Syntax.........: _IsAlphaNumKeyPressed($vDLL = 'user32.dll')
; Parameters ....: $vDLL   = the dll to use for __KeyPressCheck
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __KeyPressCheck
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsAlphaNumKeyPressed($vDLL = 'user32.dll')
	If __KeyPressCheck(65, 105, -1, $vDLL) Then Return 1
	Return 0
EndFunc   ;==>_IsAlphaNumKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsFuncKeyPressed
; Description ...: Returns if any function key is pressed
; Syntax.........: _IsFuncKeyPressed($vDLL = 'user32.dll', $sExtended = 1)
; Parameters ....: $vDLL   = the dll to use for __KeyPressCheck
;				   $sExtended - One of the following:
;				   1 - check for F1 to F24 keys
;				   0 - check for F1 to F12 keys
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __KeyPressCheck
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsFuncKeyPressed($vDLL = 'user32.dll', $sExtended = 1)
	If __KeyPressCheck(112, 123, -1, $vDLL) Then Return 1
	If $sExtended = 1 Then
		If __KeyPressCheck(124, 135, -1, $vDLL) Then Return 1
	EndIf
	Return 0
EndFunc   ;==>_IsFuncKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsArrowKeyPressed
; Description ...: Returns if any arrow key is pressed
; Syntax.........: _IsArrowKeyPressed($vDLL = 'user32.dll')
; Parameters ....: $vDLL   = the dll to use for __KeyPressCheck
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __KeyPressCheck
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsArrowKeyPressed($vDLL = 'user32.dll')
	If __KeyPressCheck(37, 40, -1, $vDLL) Then Return 1
	Return 0
EndFunc   ;==>_IsArrowKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsMouseKeyPressed
; Description ...: Returns if any mouse key is pressed
; Syntax.........: _IsMouseKeyPressed($vDLL = 'user32.dll')
; Parameters ....: $vDLL   = the dll to use for __KeyPressCheck
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __KeyPressCheck
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsMouseKeyPressed($vDLL = 'user32.dll')
	If __KeyPressCheck(1, 6, -1, $vDLL) Then Return 1
	Return 0
EndFunc   ;==>_IsMouseKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsWheelKeyScroll
; Description ...: Returns if the mouse wheel is scrolled
; Syntax.........: _IsWheelKeyScroll()
; Parameters ....:
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: MrCreator
; Modified.......: MrCreator
; Remarks .......:
; Related .......: __WheelKeyScroll
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsWheelKeyScroll()
	Local Const $WH_MOUSE_LL = 14
	
	Local $hCallback_KeyHook = DllCallbackRegister('__WheelKeyScroll_Callback', 'int', 'int;ptr')
	Local $hM_Module = DllCall('kernel32.dll', 'hwnd', 'GetModuleHandle', 'ptr', 0)
	
	Local $hM_Hook = DllCall('user32.dll', 'hwnd', 'SetWindowsHookEx', 'int', $WH_MOUSE_LL, _
			'ptr', DllCallbackGetPtr($hCallback_KeyHook), 'hwnd', $hM_Module[0], 'dword', 0)
	
	Sleep(100) ;Wait some moments until the variable is set by callback function
	
	If IsPtr($hCallback_KeyHook) Then
		DllCallbackFree($hCallback_KeyHook)
		$hCallback_KeyHook = 0
	EndIf
	
	If IsArray($hM_Hook) And $hM_Hook[0] > 0 Then
		DllCall('user32.dll', 'int', 'UnhookWindowsHookEx', 'hwnd', $hM_Hook[0])
		$hM_Hook[0] = 0
	EndIf
	
	If $IsWheelKeyScroll = True Then
		$IsWheelKeyScroll = False
		Return 1
	EndIf
EndFunc   ;==>_IsWheelKeyScroll


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsTimeKeyPressed
; Description ...: Returns the pressed time of the specified key
; Syntax.........: _IsTimeKeyPressed($sHexKey, $format = 'ms', $vDLL = 'user32.dll')
; Parameters ....: $sHexKey = Hexadecimal key
;				   $format - One of the following:
;				   ms - returns the time in milisecond
;				   sec - returns the time in second
;				   $vDLL   = the dll to use for _IsPressed
; Return values .: Success - Returns 1
;                  Failure - Returns -1
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsTimeKeyPressed($sHexKey, $sformat = 'ms', $vDLL = 'user32.dll')
	Local $vInit, $vDiffKey
	If _IsPressed($sHexKey, $vDLL) Then
		$vInit = TimerInit()
		While _IsPressed($sHexKey, $vDLL)
			$vDiffKey = TimerDiff($vInit)
		WEnd
		If $sformat = 'ms' Then Return $vDiffKey
		If $sformat = 'sec' Then Return ($vDiffKey / 1000)
	EndIf
	Return -1
EndFunc   ;==>_IsTimeKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsKeyDoublePressed
; Description ...: Returns if the specified key is 'double pressed'
; Syntax.........: _IsKeyDoublePressed($sHexKey, $stimer = 150)
; Parameters ....: $sHexKey = Hexadecimal key
;				   $timer = limit of time between presses of the key for 'double pressed'
;				   $vDLL   = the dll to use for _IsPressed
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsKeyDoublePressed($sHexKey, $stimer = 150)
	Local $vInit
	While Not _IsPressed($sHexKey)
	WEnd ;Wait for key pressed
	While _IsPressed($sHexKey)
	WEnd ;Wait for key release
	$vInit = TimerInit()
	While Not _IsPressed($sHexKey)
	WEnd ;Wait for key pressed
	
	If TimerDiff($vInit) < $stimer Then Return 1
	Return 0
EndFunc   ;==>_IsKeyDoublePressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _IsSpecialKeyPressed
; Description ...: Returns if any special key is pressed (non alphabetic, numeric and function)
; Syntax.........: _IsSpecialKeyPressed($vDLL = 'user32.dll')
; Parameters ....: $vDLL   = the dll to use for _IsPressed
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _IsSpecialKeyPressed($vDLL = 'user32.dll')
	If __KeyPressCheck(8, 36, -1, $vDLL) Then Return 1
	If __KeyPressCheck(41, 46, -1, $vDLL) Then Return 1
	If __KeyPressCheck(91, 92, -1, $vDLL) Then Return 1
	If __KeyPressCheck(106, 111, -1, $vDLL) Then Return 1
	If __KeyPressCheck(136, 221, -1, $vDLL) Then Return 1
	Return 0
EndFunc   ;==>_IsSpecialKeyPressed


; #FUNCTION# ;===============================================================================
;
; Name...........: _GetKeyByHex
; Description ...: Returns the alphabetic key of specified hexadecimal key
; Syntax.........: _GetKeyByHex($sHexKey)
; Parameters ....: $sHexKey = Hexadecimal key
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __GetKeyType
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _GetKeyByHex($sHexKey)
	Return __GetKeyType($sHexKey)
	Return 0
EndFunc   ;==>_GetKeyByHex


; #FUNCTION# ;===============================================================================
;
; Name...........: _GetKeyByAlpha
; Description ...: Returns the hexadecimal key of specified alphabetic key
; Syntax.........: _GetKeyByAlpha($sAlphaKey)
; Parameters ....: $sAlphaKey = Alphabetic key
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......: __GetKeyType
; Link ..........;
; Example .......; Yes
;
; ;==========================================================================================
Func _GetKeyByAlpha($sAlphaKey)
	Return __GetKeyType($sAlphaKey, 1)
	Return 0
EndFunc   ;==>_GetKeyByAlpha



#Region Internal
; #FUNCTION# ;===============================================================================
;
; Name...........: __OnAutoItExit
; Description ...: On AutoIt exit, the 'user32.dll' is closed
; Syntax.........:
; Parameters ....:
; Return values .:
; Author ........: FireFox
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........;
; Example .......; No
;
; ;==========================================================================================
Func __OnAutoItExit()
	DllClose($vUser32)
EndFunc   ;==>__OnAutoItExit


; #FUNCTION# ;===============================================================================
;
; Name...........: __WheelKeyScroll_Callback
; Description ...: Declare the variable $IsWheelKeyScroll
; Syntax.........: __WheelKeyScroll_Callback($wParam)
; Parameters ....: $nCode, $wParam = params of DllCallbackRegister
; Return values .: Success / Failure - Returns 0
; Author ........: MrCreator
; Modified.......:
; Remarks .......:
; Related .......: _IsWheelKeyScroll
; Link ..........;
; Example .......; No
;
; ;==========================================================================================
Func __WheelKeyScroll_Callback($nCode, $wParam)
	Local Const $MOUSE_WheelSCROLL_EVENT = 522
	Local $iEvent = BitAND($wParam, 0xFFFF)
	$IsWheelKeyScroll = ($iEvent = $MOUSE_WheelSCROLL_EVENT)
	Return 0
EndFunc   ;==>__WheelKeyScroll_Callback



; #FUNCTION# ;===============================================================================
;
; Name...........: __KeyPressCheck
; Description ...: Check if specified keys are pressed
; Syntax.........: __KeyPressCheck($iStart, $iFinish, $iHexKey = -1, $vDLL = 'user32.dll')
; Parameters ....: $iStart = the start key to check
;				   $iFinish = the last key to check
;				   $iHexKey - One of the following:
;				   -1 = use number key
;				   0 = use hexadecimal key
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: Valuater
; Modified.......:
; Remarks .......: Thanks Valuater... 8)
; Related .......: _Is[...]KeyPressed functions
; Link ..........;
; Example .......; No
;
; ;==========================================================================================
Func __KeyPressCheck($iStart, $iFinish, $iHexKey = -1, $vDLL = 'user32.dll')
	Local $iKey, $ia_R
	For $iKey = $iStart To $iFinish
		If $iHexKey == -1 Then $ia_R = DllCall($vDLL, 'int', 'GetAsyncKeyState', 'int', '0x' & Hex($iKey, 2))
		If $iHexKey <> -1 Then $ia_R = DllCall($vDLL, 'int', 'GetAsyncKeyState', 'int', '0x' & $iHexKey)
		If Not @error And BitAND($ia_R[0], 0x8000) = 0x8000 Then Return 1
	Next
	Return 0
EndFunc   ;==>__KeyPressCheck


; #FUNCTION# ;===============================================================================
;
; Name...........: __GetKeyType
; Description ...: Returns alphabetic for hexadecimal key specified and vice-versa
; Syntax.........: __GetKeyType($iKeyIn, $Type = 0)
; Parameters ....: $iKeyIn = Hexadecimal or alphabetic key
;				   $Type - One of the following:
;				   0 = returns alphabetic key
;				   1 = returns hexadecimal key
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: Valuater
; Modified.......:
; Remarks .......: Thanks Valuater... 8)
; Related .......: _GetKeyByHex ; _GetKeyByAlpha
; Link ..........;
; Example .......; No
;
; ;==========================================================================================
Func __GetKeyType($iKeyIn, $Type = 0)
	If $iKeyIn = '' Then Return -1
	
	Local $s_String = '|01_LeftMouse|02_RightMouse|04_MiddleMouse|05_X1Mouse|06_X2Mouse|08_BACKSPACE|09_TAB|0C_CLEAR|' & _
			'0D_ENTER|10_SHIFT|11_CTRL|12_ALT|13_PAUSE|14_CAPS LOCK|1B_ESC|20_SPACEBAR|21_PAGE UP|22_PAGE DOWN|' & _
			'23_END|24_HOME|25_LEFT|26_UP|27_RIGHT|28_DOWN|29_SELECT|2A_PRINT|2B_EXECUTE|2C_PRINT SCREEN|2D_INS|2E_DEL|' & _
			'30_0|31_1|32_2|33_3|34_4|35_5|36_6|37_7|38_8|39_9|41_A|42_B|43_C|44_D|45_E|46_F|47_G|48_H|49_I|4A_J|4B_K|4C_L|4D_M|4E_N|' & _
			'4F_O|50_P|51_Q|52_R|53_S|54_T|55_U|56_V|57_W|58_X|59_Y|5A_Z|5B_Left Windows|5C_Right Windows|60_Num 0|61_Num 1|' & _
			'62_Num 2|63_Num 3|64_Num 4|65_Num 5|66_Num 6|67_Num 7|68_Num 8|69_Num 9|6A_Multiply|6B_Add|' & _
			'6C_Separator|6D_Subtract|6E_Decimal|6F_Divide|70_F1|71_F2|72_F3|73_F4|74_F5|75_F6|76_F7|77_F8|78_F9|' & _
			'79_F10|7A_F11|7B_F12|7C_F13|7D_F14|7E_F15|7F_F16|80H_F17|81HF18|82HF19|83HF20|84HF21|85HF22|' & _
			'86H_F23|87H_F24|90_NUM LOCK|91_SCROLL LOCK|A0_Left SHIFT|A1_Right SHIFT|A2_Left CTRL|A3_Right CTRL|' & _
			'A4_Left MENU|A5_Right Menu|BA_;|BB_=|BC_,|BD_ |BE_.|BF_/|C0_`|DB_[|DC_\|DD_]|'
	
	If $Type == 0 Then
		If (StringLeft(StringInStr($s_String, $iKeyIn) - 1, 1) <> '|') Then
			$iKeyIn = StringTrimLeft($s_String, (StringInStr($s_String, $iKeyIn, 0, -1) + StringLen($iKeyIn) - 1))
			$s_String = StringReplace(StringLeft($iKeyIn, (StringInStr($iKeyIn, '|') - 1)), '_', '')
		Else
			$iKeyIn = StringTrimLeft($s_String, (StringInStr($s_String, $iKeyIn) + StringLen($iKeyIn) - 1))
			$s_String = StringReplace(StringLeft($iKeyIn, (StringInStr($iKeyIn, '|') - 1)), '_', '')
		EndIf
	ElseIf $Type == 1 Then
		If (StringLeft(StringInStr($s_String, $iKeyIn) + StringLen($iKeyIn) + 1, 1) <> '|') Then
			$iKeyIn = StringLeft($s_String, StringInStr($s_String, $iKeyIn, 0, -1) - 1)
			$s_String = StringTrimLeft($iKeyIn, StringInStr($iKeyIn, '|', 2, -1))
		Else
			$iKeyIn = StringLeft($s_String, StringInStr($s_String, $iKeyIn) - 1)
			$s_String = StringTrimLeft($iKeyIn, StringInStr($iKeyIn, '|', 2, -1))
		EndIf
	EndIf
	If $s_String <> '' Then
		Return $s_String
	EndIf
	Return -1
EndFunc   ;==>__GetKeyType
#EndRegion Internal