#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=..\..\..\ICON\SHELL32\026_shell32.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_UseAnsi=y
#AutoIt3Wrapper_Res_Description=d3mon Corporation
#AutoIt3Wrapper_Res_Fileversion=1.0
#AutoIt3Wrapper_Res_LegalCopyright=d3mon Corporation. All rights reserved.
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include <Include\GUICtrlSetOnHover_UDF.au3> ; http://www.autoitscript.com/forum/index.php?showtopic=55120
#include <Include\IsPressed_UDF.au3> ; http://www.autoitscript.com/forum/index.php?showtopic=86296
#include <Include\ModernMenuRaw.au3> ; http://www.autoitscript.com/forum/index.php?showtopic=20967
#NoTrayIcon
;

#Region Opt  & Install
Opt('GUIOnEventMode', 1)
Opt('TrayOnEventMode', 1)
Opt('TrayMenuMode', 1)

;~ _FileInstallFolder('Picture\*.*', @TempDir, 1, True)
#EndRegion Opt  & Install
;

#Region Tray
$tray = _TrayIconCreate('Shutdown - d3monCorp')
_TrayCreateContextMenu($tray)
_TrayCreateItem('Show')
_TrayItemSetIcon(-1, 'shell32.dll', -145)
GUICtrlSetOnEvent(-1, '_SHOW')
_TrayCreateItem('Hide')
_TrayItemSetIcon(-1, 'shell32.dll', -154)
GUICtrlSetOnEvent(-1, '_HIDE')
_TrayCreateItem('')
_TrayCreateItem('Exit')
_TrayItemSetIcon(-1, 'shell32.dll', -028)
GUICtrlSetOnEvent(-1, '_Exit')
_TrayIconSetState($tray, @SW_SHOW)
#EndRegion Tray
;

Local $display = ' http://www.autoitscript.com/ -' ; Shutdown ~ d3mon Corp - AutoIt Script -
Local $timer = False, $CGUI = True, $shuthour, $shutmin, $o_text = StringLen($display)

#Region GUI
$GUI = GUICreate('Shutdown', 165, 90, -1, -1, 0x80000000 + 0x00800000)
GUISetOnEvent(-7, '_DRAG', $GUI)
GUICtrlCreatePic('Picture\back_pic.JPG', 0, 0, 165, 90, 128)

#Region SysMenu
GUICtrlCreateLabel('Shutdown', 5, 0, 75, 15)
GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetBkColor(-1, -2)

$title = GUICtrlCreateLabel('Shutdown - d3mon Corporation ', 2, 77, 160, 15)
GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetBkColor(-1, -2)

$minimize = GUICtrlCreatePic('Picture\Minimize.bmp', 103, 1, 33, 13)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_MINIMIZE')

$close = GUICtrlCreatePic('Picture\Close.bmp', 136, 1, 30, 13)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_HIDE')

$config = GUICtrlCreatePic('Picture\Config.bmp', 75, 1, 30, 13)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_GCONFIG')
#EndRegion SysMenu

#Region Hour
$hour = GUICtrlCreateInput(@HOUR, 5, 30, 45, 30, 4096)
GUICtrlSetFont($hour, 20)

$upl = GUICtrlCreatePic('Picture\up.bmp', 50, 30, 21, 15)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_upl')

$downl = GUICtrlCreatePic('Picture\down.bmp', 50, 45, 21, 15)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_downl')
#EndRegion Hour

#Region :
GUICtrlCreateLabel(':', 79, 32)
GUICtrlSetBkColor(-1, -2)
GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetFont(-1, 15, 700)
#EndRegion :

#Region min
$min = GUICtrlCreateInput(@MIN, 95, 30, 45, 30, 4096)
GUICtrlSetFont($min, 20)

$upr = GUICtrlCreatePic('Picture\up.bmp', 140, 30, 21, 15)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_upr')

$downr = GUICtrlCreatePic('Picture\down.bmp', 140, 45, 21, 15)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_downr')
#EndRegion min

GUISetBkColor(0xFFFFFF, $GUI)
;~ DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 250, 'long', 0x00080000)
GUISetState(@SW_SHOW, $GUI)
#EndRegion GUI

#Region 2GUI
$2GUI = GUICreate('Config', 165, 75, -1, @DesktopHeight + 100, 0x80000000 + 0x00800000, -1, $GUI)
GUISetOnEvent(-7, '_DRAG', $2GUI)
GUICtrlCreatePic('Picture\back_pic2.JPG', 0, 0, 165, 75, 128)

$shutdown = GUICtrlCreateRadio('Shutdown', 15, 18, 85)
GUICtrlSetState($shutdown, 1)
$reboot = GUICtrlCreateRadio('Reboot', 15, 39, 85)

$logoff = GUICtrlCreateRadio('Log-off', 100, 18, 65)
$standby = GUICtrlCreateRadio('Standby', 100, 39, 65)

$apply = GUICtrlCreatePic('Picture\Apply.bmp', 55, 62, 55, 14)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_Apply')

GUISetState(@SW_SHOW, $2GUI)
#EndRegion 2GUI
;

#Region Hover
Func Hover_Func($CtrlID)
	Switch $CtrlID
		Case $close
			GUICtrlSetImage($CtrlID, 'Picture\Close-o.bmp')
		Case $minimize
			GUICtrlSetImage($CtrlID, 'Picture\Minimize-o.bmp')
		Case $config
			GUICtrlSetImage($CtrlID, 'Picture\Config-o.bmp')
		Case $apply
			GUICtrlSetImage($CtrlID, 'Picture\Apply-o.bmp')
		Case $upl
			GUICtrlSetImage($CtrlID, 'Picture\up-o.bmp')
		Case $downl
			GUICtrlSetImage($CtrlID, 'Picture\down-o.bmp')
		Case $upr
			GUICtrlSetImage($CtrlID, 'Picture\up-o.bmp')
		Case $downr
			GUICtrlSetImage($CtrlID, 'Picture\down-o.bmp')
	EndSwitch
EndFunc   ;==>Hover_Func

Func Leave_Hover_Func($CtrlID)
	Switch $CtrlID
		Case $close
			GUICtrlSetImage($CtrlID, 'Picture\Close.bmp')
		Case $minimize
			GUICtrlSetImage($CtrlID, 'Picture\Minimize.bmp')
		Case $config
			GUICtrlSetImage($CtrlID, 'Picture\Config.bmp')
		Case $apply
			GUICtrlSetImage($CtrlID, 'Picture\Apply.bmp')
		Case $upl
			GUICtrlSetImage($CtrlID, 'Picture\up.bmp')
		Case $downl
			GUICtrlSetImage($CtrlID, 'Picture\down.bmp')
		Case $upr
			GUICtrlSetImage($CtrlID, 'Picture\up.bmp')
		Case $downr
			GUICtrlSetImage($CtrlID, 'Picture\down.bmp')
	EndSwitch
EndFunc   ;==>Leave_Hover_Func
#EndRegion Hover

#Region Func
Func _Apply()
	GUICtrlSetImage($apply, 'Picture\Apply-p.bmp')
	While _IsPressed('01')
	WEnd
	If (GUICtrlRead($hour) = '') Then GUICtrlSetData($hour, '00')
	If (GUICtrlRead($min) = '') Then GUICtrlSetData($min, '00')
	If (GUICtrlRead($hour) = @HOUR) And (GUICtrlRead($min) = @MIN) Then
		$msgbox = MsgBox(49, 'Shutdown - Warning !', 'You have selected to shutdown now, Continue ?')
		If $msgbox = 2 Then Return GUICtrlSetImage($apply, 'Apply.bmp')
	EndIf
	If $timer = False Then
		GUICtrlSetColor($hour, 0xFF0000)
		GUICtrlSetColor($min, 0xFF0000)
		$shuthour = GUICtrlRead($hour)
		$shutmin = GUICtrlRead($min)
		$timer = True
	Else
		GUICtrlSetColor($hour, 0x000000)
		GUICtrlSetColor($min, 0x000000)
		GUICtrlSetData($hour, $shuthour)
		GUICtrlSetData($min, $shutmin)
		$timer = False
	EndIf
	GUICtrlSetImage($apply, 'Picture\Apply.bmp')
EndFunc   ;==>_Apply

#Region up/down
Func _upl()
	GUICtrlSetImage($upl, 'Picture\up-p.bmp')
	While _IsPressed('01')
	WEnd
	$rhour = GUICtrlRead($hour)
	If $rhour = '23' Then GUICtrlSetData($hour, '00')
	If $rhour < '09' Then GUICtrlSetData($hour, '0' & $rhour + 1)
	If $rhour >= '09' Then GUICtrlSetData($hour, $rhour + 1)
	GUICtrlSetImage($upl, 'Picture\up.bmp')
EndFunc   ;==>_upl

Func _downl()
	GUICtrlSetImage($downl, 'Picture\down-p.bmp')
	While _IsPressed('01')
	WEnd
	$rhour = GUICtrlRead($hour)
	If $rhour = '00' Then GUICtrlSetData($hour, '23')
	If $rhour < '11' Then GUICtrlSetData($hour, '0' & $rhour - 1)
	If $rhour >= '11' Then GUICtrlSetData($hour, $rhour - 1)
	GUICtrlSetImage($downl, 'Picture\down.bmp')
EndFunc   ;==>_downl

Func _upr()
	GUICtrlSetImage($upr, 'Picture\up-p.bmp')
	While _IsPressed('01')
	WEnd
	$rmin = GUICtrlRead($min)
	If $rmin = '59' Then GUICtrlSetData($min, '00')
	If $rmin < '09' Then GUICtrlSetData($min, '0' & $rmin + 1)
	If $rmin >= '09' Then GUICtrlSetData($min, $rmin + 1)
	GUICtrlSetImage($upr, 'Picture\up.bmp')
EndFunc   ;==>_upr

Func _downr()
	GUICtrlSetImage($downr, 'Picture\down-p.bmp')
	While _IsPressed('01')
	WEnd
	$rmin = GUICtrlRead($min)
	If $rmin = '00' Then GUICtrlSetData($min, '59')
	If $rmin < '11' Then GUICtrlSetData($min, '0' & $rmin - 1)
	If $rmin >= '11' Then GUICtrlSetData($min, $rmin - 1)
	GUICtrlSetImage($downr, 'Picture\down.bmp')
EndFunc   ;==>_downr
#EndRegion up/down

Func _DRAG()
	$wgp = WinGetPos($GUI)
	$mgp = MouseGetPos()
	While _IsPressed('01')
		$mgp1 = MouseGetPos()
		WinMove($GUI, '', $wgp[0] - ($mgp[0] - $mgp1[0]), $wgp[1] - ($mgp[1] - $mgp1[1]))
		WinMove($2GUI, '', $wgp[0] - ($mgp[0] - $mgp1[0]), $wgp[1] - ($mgp[1] - $mgp1[1]) + 100)
	WEnd
EndFunc   ;==>_DRAG

Func _HIDE()
	GUICtrlSetImage($close, 'Picture\Close-p.bmp')
	While _IsPressed('01')
	WEnd
	$CGUI = False
;~ 	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $2GUI, 'int', 200, 'long', 0x00050008)
	GUISetState(@SW_HIDE, $2GUI)
;~ 	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 200, 'long', 0x00090000)
	GUISetState(@SW_HIDE, $GUI)
	GUICtrlSetImage($close, 'Picture\Close.bmp')
	
	#Region TrayTip
	If $timer = True Then
		_TrayTip($tray, 'Shutdown - Warning', 'Shutdown will continue to run !', 3, 2)
		Sleep(2500) ; show traytip 2.5 sec
		_TrayTip($tray, '', '', 0)
	EndIf
	#EndRegion TrayTip
EndFunc   ;==>_HIDE

Func _MINIMIZE()
	GUICtrlSetImage($minimize, 'Picture\Minimize-p.bmp')
	While _IsPressed('01')
	WEnd
	GUISetState(@SW_MINIMIZE, $GUI)
	GUICtrlSetImage($minimize, 'Picture\Minimize.bmp')
EndFunc   ;==>_MINIMIZE

Func _SHOW()
;~ 	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 250, 'long', 0x00080000)
	GUISetState(@SW_SHOW, $GUI)
EndFunc   ;==>_SHOW

#Region Config
Func _GCONFIG()
	If $CGUI = True Then
		_HCONFIG()
	Else
		_SCONFIG()
	EndIf
EndFunc   ;==>_GCONFIG

Func _SCONFIG()
	GUICtrlSetImage($config, 'Picture\Config-p.bmp')
	While _IsPressed('01')
	WEnd
	$CGUI = True
	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $2GUI, 'int', 250, 'long', 0x00040004)
	GUISetState(@SW_SHOW, $2GUI)
	GUICtrlSetImage($config, 'Picture\Config.bmp')
EndFunc   ;==>_SCONFIG

Func _HCONFIG()
	GUICtrlSetImage($config, 'Picture\Config-p.bmp')
	While _IsPressed('01')
	WEnd
	$CGUI = False
	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $2GUI, 'int', 200, 'long', 0x00050008)
	GUISetState(@SW_HIDE, $2GUI)
	GUICtrlSetImage($config, 'Picture\Config.bmp')
EndFunc   ;==>_HCONFIG
#EndRegion Config

Func _GetCountdownTimer()
	$hourcd = @HOUR - $shuthour
	$mincd = @MIN - $shutmin
	If $hourcd < '10' Then
		GUICtrlSetData($hour, '0' & StringTrimLeft($hourcd, 1))
		If ($hourcd = 0) Then GUICtrlSetData($hour, '00')
	Else
		GUICtrlSetData($hour, $hourcd)
	EndIf
	If $mincd < '10' Then
		GUICtrlSetData($min, '0' & StringTrimLeft($mincd, 1))
		If ($mincd = 0) Then GUICtrlSetData($min, '00')
	Else
		GUICtrlSetData($min, $mincd)
	EndIf
EndFunc   ;==>_GetCountdownTimer

Func _Exit()
	_TrayIconDelete($tray)
	Exit
EndFunc   ;==>_Exit
#EndRegion Func
;

#Region While
While 1
	Sleep(100)
	_AnimateText($title, $display, 32, 2)
	If $timer = True Then
		_GetCountdownTimer()
		WinSetTitle($GUI, '', 'Shutdown ' & GUICtrlRead($hour) & 'h : ' & GUICtrlRead($min) & 'min')
		If (GUICtrlRead($hour) = '00') And (GUICtrlRead($min) = '00') Then
			If (GUICtrlRead($shutdown) = 1) Then Exit Shutdown(5)
			If (GUICtrlRead($reboot) = 1) Then Exit Shutdown(6)
			If (GUICtrlRead($logoff) = 1) Then Exit Shutdown(4)
			If (GUICtrlRead($standby) = 1) Then Shutdown(32)
		EndIf
	EndIf
WEnd
#EndRegion While
;


#Region FireFox UDF
; #FUNCTION# ;===============================================================================
;
; Name...........: _AnimateText
; Description ...: Animate a text in different ways
; Syntax.........: _AnimateText($Ctrl_ID, $s_text, $len, $way = 1)
; Parameters ....: $Ctrl_ID	= the control id to animate text
;				   $s_text	= text to animate
;				   $len	= Animate length limit
;				   $way	- One of the following:
;				   1 =	Animate from Left
;				   2 =	Animate from Right
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......: $o_text = 1 for $way = 1 | $o_text = StringLen($s_text) for $way = 2
; Related .......:
; Link ..........;
; Example .......;
;
; ;==========================================================================================
Func _AnimateText($Ctrl_ID, $s_text, $len, $way = 1)
	If $way = 1 Then
		$_text = GUICtrlRead($Ctrl_ID)
		$n_text = StringRight($s_text, $o_text) & $s_text
		GUICtrlSetData($Ctrl_ID, StringLeft($n_text, $len))
		$o_text += 1
		If $o_text = StringLen($s_text) Then $o_text = 1
	EndIf
	If $way = 2 Then
		$_text = GUICtrlRead($Ctrl_ID)
		$n_text = StringRight($s_text, $o_text) & $s_text
		GUICtrlSetData($Ctrl_ID, StringLeft($n_text, $len))
		$o_text -= 1
		If $o_text < 1 Then $o_text = StringLen($s_text)
	EndIf
	If Not @error Then Return 1
	Return 0
EndFunc   ;==>_AnimateText


; #FUNCTION# ;===============================================================================
;
; Name...........: _FileInstallFolder
; Description ...: Install file(s) from a folder
; Syntax.........: _FileInstallFolder($sSource, $sDest, $nFlag = 1, $sCompiled = False)
; Parameters ....: $sSource	= Source folder to get file(s) from
;				   $sDest	= Destination to install file(s) to
;				   $nFlag	= According to the flag of FileInstall
;				   $sCompiled - One of the following:
;				   False = Always install file(s)
;				   True = Only install file(s) when the script is compiled
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......: this function is faster with _WinAPI_FileFind :
;				   http://www.autoitscript.com/forum/index.php?showtopic=90545
; Related .......:
; Link ..........;
; Example .......;
;
; ;==========================================================================================
Func _FileInstallFolder($sSource, $sDest, $nFlag = 1, $sCompiled = False)
	Local $sFile, $sNext, $sDir
	If Not $sCompiled Then
		$sFile = FileFindFirstFile($sSource)
		While 1
			$sNext = FileFindNextFile($sFile)
			If @error Then ExitLoop ;No more files
			$sDir = StringRegExpReplace($sSource, '^.*\\', '')
			If @error Then Return SetError(1, 0, 0)
			If Not FileExists($sDir) Then DirCreate($sDir)
			If @error Then Return SetError(2, 0, 0)
			FileInstall($sNext, $sDest & '\' & $sDir & '\' & $sNext, $nFlag)
			If @error Then Return SetError(3, 0, 0)
		WEnd
	ElseIf $sCompiled And @Compiled Then
		$sFile = FileFindFirstFile($sSource)
		While 1
			$sNext = FileFindNextFile($sFile)
			If @error Then ExitLoop ;No more files
			$sDir = StringRegExpReplace($sSource, '^.*\\', '')
			If @error Then Return SetError(1, 0, 0)
			If Not FileExists($sDir) Then DirCreate($sDir)
			If @error Then Return SetError(2, 0, 0)
			FileInstall($sNext, $sDest & '\' & $sDir & '\' & $sNext, $nFlag)
			If @error Then Return SetError(3, 0, 0)
		WEnd
	EndIf
	Return 1
EndFunc   ;==>_FileInstallFolder
#EndRegion FireFox UDF